<?php

namespace App\Http\Controllers\Admin\Payment;

use Stripe;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Support\Facades\Session;
use App\Repositories\Interfaces\Admin\SettingInterface;
use App\Http\Requests\Admin\PaymentGateway\PaymentGatewayRequest;
use App\Repositories\Interfaces\Admin\Payment\PaymentGatewayInterface;

class PaymentGatewayController extends Controller
{
    protected $settings;
    public function __construct(SettingInterface $settings){

        $this->settings = $settings;

    }
    public function index(){
        return view('admin.settings.payment-gateway.index');
    }

    public function paymentUpdate(PaymentGatewayRequest $request)
    {
        if (config('app.demo_mode')):
            Toastr::info(__('This function is disabled in demo server.'));
            return redirect()->back();
        endif;

        DB::beginTransaction();
        try {
            $this->settings->update($request);
            Toastr::success(__('Payment Methods Updated Successfully'));
            DB::commit();
            return redirect()->back()->withInput();
        } catch (\Exception $e) {
            DB::rollBack();
            Toastr::error($e->getMessage());
            return redirect()->back();
        }
    }

    public function testPayment(){
//        return view('admin.settings.payment-gateway.test-payment');
    }
    public function stripePayment(Request $request){
        Stripe\Stripe::setApiKey(settingHelper('stripe_secret'));
        $data = Stripe\Charge::create([
            "amount"=>200*100,
            "currency"=>"usd",
            "source"=>$request->stripeToken,
            "description"=>"Test payment from expert rohila 2"
        ]);
        echo "<pre>"; print_r($data); die();
        Session::flash("success","Payment successfully!");

        return back();
    }

    public function update(Request $request)
    {
        if (config('app.demo_mode')):
            $response['message']    = __('This function is disabled in demo server.');
            $response['title']      = __('Ops..!');
            $response['status']     = 'error';
            return response()->json($response);
        endif;

        if(!checkEmptyProvider($request['data']['id'])):
            $response['message']    = __('You can active this service when you will configure all credentials');
            $response['title']      = __('Ops..!');
            $response['status']     = 'error';
            return response()->json($response);
        else:
            try {
                if ($this->settings->statusChange($request['data'])):
                    $response['message']    = __('Updated Successfully');
                    $response['title']      = __('Success');
                    $response['status']     = 'success';
                    $response['data']     = 'success';
                    return response()->json($response);
                endif;
            } catch (\Exception $e){
                $response['message']    = $e->getMessage();
                $response['title']      = ('Ops..!');
                $response['status']     = 'error';
                return response()->json($response);
            }
        endif;
    }
}
